
---
# RS485 Isolator 3 Click

> [RS485 Isolator 3 Click](https://www.mikroe.com/?pid_product=MIKROE-5597) demo application is developed using
the [NECTO Studio](https://www.mikroe.com/necto), ensuring compatibility with [mikroSDK](https://www.mikroe.com/mikrosdk)'s
open-source libraries and tools. Designed for plug-and-play implementation and testing, the demo is fully compatible with
all development, starter, and mikromedia boards featuring a [mikroBUS&trade;](https://www.mikroe.com/mikrobus) socket.

<p align="center">
  <img src="https://www.mikroe.com/?pid_product=MIKROE-5597&image=1" height=300px>
</p>

---

#### Click Library

- **Author**        : Stefan Ilic
- **Date**          : Mar 2023.
- **Type**          : UART type

# Software Support

## Example Description

> This example reads and processes data from RS485 Isolator 3 Clicks.

### Example Libraries

- MikroSDK.Board
- MikroSDK.Log
- Click.RS485Isolator3

### Example Key Functions

- `rs485isolator3_cfg_setup` Config Object Initialization function.
```c
void rs485isolator3_cfg_setup ( rs485isolator3_cfg_t *cfg );
```

- `rs485isolator3_init` Initialization function.
```c
err_t rs485isolator3_init ( rs485isolator3_t *ctx, rs485isolator3_cfg_t *cfg );
```

- `rs485isolator3_default_cfg` Click Default Configuration function.
```c
void rs485isolator3_default_cfg ( rs485isolator3_t *ctx );
```

- `rs485isolator3_enable_receiver_input` RS485 Isolator 3 enable receiver input function.
```c
void rs485isolator3_enable_receiver_input ( rs485isolator3_t *ctx );
```

- `rs485isolator3_disable_receiver_input` RS485 Isolator 3 disable receiver input function.
```c
void rs485isolator3_disable_receiver_input ( rs485isolator3_t *ctx );
```

- `rs485isolator3_disable_output` RS485 Isolator 3 disable output function.
```c
void rs485isolator3_disable_output ( rs485isolator3_t *ctx );
```

### Application Init

> Initializes the driver and enables the selected mode.

```c
void application_init ( void ) 
{
    log_cfg_t log_cfg;  /**< Logger config object. */
    rs485isolator3_cfg_t rs485isolator3_cfg;  /**< Click config object. */

    /** 
     * Logger initialization.
     * Default baud rate: 115200
     * Default log level: LOG_LEVEL_DEBUG
     * @note If USB_UART_RX and USB_UART_TX 
     * are defined as HAL_PIN_NC, you will 
     * need to define them manually for log to work. 
     * See @b LOG_MAP_USB_UART macro definition for detailed explanation.
     */
    LOG_MAP_USB_UART( log_cfg );
    log_init( &logger, &log_cfg );
    log_info( &logger, " Application Init " );

    // Click initialization.
    rs485isolator3_cfg_setup( &rs485isolator3_cfg );
    RS485ISOLATOR3_MAP_MIKROBUS( rs485isolator3_cfg, MIKROBUS_1 );
    if ( UART_ERROR == rs485isolator3_init( &rs485isolator3, &rs485isolator3_cfg ) ) 
    {
        log_error( &logger, " Communication init." );
        for ( ; ; );
    }
    
    rs485isolator3_default_cfg ( &rs485isolator3 );
    
#ifdef DEMO_APP_RECEIVER
    rs485isolator3_enable_receiver_input( &rs485isolator3 );
    rs485isolator3_disable_output( &rs485isolator3 );
    log_info( &logger, "---- Receiver mode ----" );
#endif 
#ifdef DEMO_APP_TRANSMITTER
    rs485isolator3_disable_receiver_input( &rs485isolator3 );
    rs485isolator3_enable_output( &rs485isolator3 );    
    log_info( &logger, "---- Transmitter mode ----" );
#endif
    
    log_info( &logger, " Application Task " );
    Delay_ms ( 100 );
}
```

### Application Task

> Depending on the selected mode, it reads all the received data or sends the desired message
 every 2 seconds.

```c
void application_task ( void ) 
{
#ifdef DEMO_APP_RECEIVER
    rs485isolator3_process( );
#endif    
    
#ifdef DEMO_APP_TRANSMITTER
    rs485isolator3_generic_write( &rs485isolator3, data_buf, strlen( data_buf ) );
    log_info( &logger, "---- Data sent ----" );
    Delay_ms ( 1000 );
    Delay_ms ( 1000 );
#endif    

}
```

## Application Output

This Click board can be interfaced and monitored in two ways:
- **Application Output** - Use the "Application Output" window in Debug mode for real-time data monitoring.
Set it up properly by following [this tutorial](https://www.youtube.com/watch?v=ta5yyk1Woy4).
- **UART Terminal** - Monitor data via the UART Terminal using
a [USB to UART converter](https://www.mikroe.com/click/interface/usb?interface*=uart,uart). For detailed instructions,
check out [this tutorial](https://help.mikroe.com/necto/v2/Getting%20Started/Tools/UARTTerminalTool).

## Additional Notes and Information

The complete application code and a ready-to-use project are available through the NECTO Studio Package Manager for 
direct installation in the [NECTO Studio](https://www.mikroe.com/necto). The application code can also be found on
the MIKROE [GitHub](https://github.com/MikroElektronika/mikrosdk_click_v2) account.

---
